﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace ContentControls
{
    public partial class App : Application
    {

        public App()
        {
            this.Startup += this.Application_Startup;
            this.Exit += this.Application_Exit;
            this.UnhandledException += this.Application_UnhandledException;

            InitializeComponent();
        }

        private void Application_Startup(object sender, StartupEventArgs e)
        {
            this.RootVisual = new MainPage();
        }

        private void Application_Exit(object sender, EventArgs e)
        {

        }

        private void Application_UnhandledException(object sender, ApplicationUnhandledExceptionEventArgs e)
        {
            // Jeśli aplikacja działa poza debuggerem, to należy zaraportować wyjątek przy użyciu
            // mechanizmu obsługi wyjątków przeglądarki. W przeglądarce IE spowoduje to wyświetlenie
            // żółtej ikony ostrzeżenia na pasku statusu, natomiast w Firefoksie - wyświetlenie
            // błędu skryptu.
            if (!System.Diagnostics.Debugger.IsAttached)
            {

                // UWAGA: To rozwiązanie pozwala aplikacji działać nawet wtedy, gdy wyjątek 
                // został zgłoszony, lecz nie obsłużony.
                // W przypadku aplikacji produkcyjnej, należałoby tu zastosować rozwiązanie,
                // które by przekazało błąd na witrynę i zatrzymało działanie aplikacji.
                e.Handled = true;
                Deployment.Current.Dispatcher.BeginInvoke(delegate { ReportErrorToDOM(e); });
            }
        }

        private void ReportErrorToDOM(ApplicationUnhandledExceptionEventArgs e)
        {
            try
            {
                string errorMsg = e.ExceptionObject.Message + e.ExceptionObject.StackTrace;
                errorMsg = errorMsg.Replace('"', '\'').Replace("\r\n", @"\n");

                System.Windows.Browser.HtmlPage.Window.Eval("throw new Error(\"Nieobsłużony błąd w aplikacji Silverlight: " + errorMsg + "\");");
            }
            catch (Exception)
            {
            }
        }
    }
}
